/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RefineHandler {
    private static final ResourceLocation REFINE = new ResourceLocation("slashblade", "tips/refine");

    public static RefineHandler getInstance() {
        return SingletonHolder.instance;
    }

    private RefineHandler() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onAnvilUpdateEvent(AnvilUpdateEvent event) {
        if (!event.getOutput().m_41619_()) {
            return;
        }
        ItemStack base = event.getLeft();
        ItemStack material = event.getRight();
        if (base.m_41619_()) {
            return;
        }
        if (!base.getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
            return;
        }
        if (material.m_41619_()) {
            return;
        }
        boolean isRepairable = base.m_41720_().m_6832_(base, material);
        if (!isRepairable) {
            return;
        }
        int level = material.getEnchantmentValue();
        if (level < 0) {
            return;
        }
        ItemStack result = base.m_41777_();
        int refineLimit = Math.max(10, level);
        int cost = 0;
        int levelCostBase = (Integer)SlashBladeConfig.REFINE_LEVEL_COST.get();
        int costResult = levelCostBase * cost;
        while (cost < material.m_41613_()) {
            costResult = levelCostBase * ++cost;
            result.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> {
                s.setProudSoulCount(s.getProudSoulCount() + Math.min(5000, level * 10));
                if (s.getRefine() < refineLimit) {
                    s.setRefine(s.getRefine() + 1);
                    if (s.getRefine() < 200) {
                        s.setMaxDamage(s.getMaxDamage() + 1);
                    }
                }
                result.m_41721_(result.m_41773_() - Math.max(1, level / 2));
                result.m_41784_().m_128365_("bladeState", (Tag)s.serializeNBT());
            });
            boolean refineable = !event.getPlayer().m_150110_().f_35937_ && event.getPlayer().f_36078_ < costResult;
            if (!refineable) continue;
            break;
        }
        event.setMaterialCost(cost);
        event.setCost(costResult);
        event.setOutput(result);
    }

    @SubscribeEvent
    public void onAnvilRepairEvent(AnvilRepairEvent event) {
        int after;
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ItemStack material = event.getRight();
        ItemStack base = event.getLeft();
        ItemStack output = event.getOutput();
        if (base.m_41619_()) {
            return;
        }
        if (!(base.m_41720_() instanceof ItemSlashBlade)) {
            return;
        }
        if (material.m_41619_()) {
            return;
        }
        boolean isRepairable = base.m_41720_().m_6832_(base, material);
        if (!isRepairable) {
            return;
        }
        int before = base.getCapability(ItemSlashBlade.BLADESTATE).map(s -> s.getRefine()).orElse(0);
        if (before < (after = output.getCapability(ItemSlashBlade.BLADESTATE).map(s -> s.getRefine()).orElse(0).intValue())) {
            AdvancementHelper.grantCriterion((ServerPlayer)event.getEntity(), REFINE);
        }
    }

    private static final class SingletonHolder {
        private static final RefineHandler instance = new RefineHandler();

        private SingletonHolder() {
        }
    }
}

